/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.earth.TaskContainerNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.earth.util.AbstractTaskRetriever;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class KeyConsoleTaskRetriever
extends AbstractTaskRetriever {
    private static Set CONSOLE_TASK_KEYS_REQUIRING_TARGET = new HashSet();
    private Map tasksMap;

    public void init(String key, Map params) throws BonsaiConfigException {
        super.init(key, params);
        String keysParam = (String)params.get("keys");
        if (keysParam == null) {
            throw new BonsaiConfigException("No task keys were specified in the XML!");
        }
        this.tasksMap = new HashMap();
        ShortObjectIdManager idManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
        String taskKey = null;
        String taskId = null;
        TaskUrl url = null;
        byte[] buffer = null;
        TaskNode node = null;
        StringTokenizer tokens = new StringTokenizer(keysParam, ";");
        while (tokens.hasMoreTokens()) {
            taskKey = tokens.nextToken();
            objId.setKeyProperty("Name", taskKey);
            taskId = idManager.getShortId(objId);
            if (taskId == null) continue;
            url = CONSOLE_TASK_KEYS_REQUIRING_TARGET.contains(taskKey) ? new TaskUrl(taskId, 2, this.getHMCShortId()) : new TaskUrl(taskId, 1);
            buffer = reader.getBuffer(taskId);
            node = new TaskNode(taskId, new UIInfo(UIObjectProperties.getName(buffer), UIObjectProperties.getCaption(buffer), UIObjectProperties.getImageName(buffer)), true, url);
            this.tasksMap.put(node, new UserRolePermissionsSet(objId));
        }
    }

    public List getTasks(TaskContainerNode node, UISession session) {
        SortedList permittedTasks = new SortedList(TaskNode.getTaskNodeComparator());
        Set userRoles = session.getUserRoles();
        TaskNode taskNode = null;
        Iterator i = this.tasksMap.keySet().iterator();
        while (i.hasNext()) {
            taskNode = (TaskNode)i.next();
            if (!((UserRolePermissionsSet)this.tasksMap.get(taskNode)).isPermitted(userRoles)) continue;
            permittedTasks.add(taskNode.getNoChildrenClone());
        }
        return permittedTasks;
    }

    public Set getPermittedUserRoles() {
        HashSet permittedRoles = new HashSet();
        Iterator i = this.tasksMap.values().iterator();
        while (i.hasNext()) {
            permittedRoles.addAll(((UserRolePermissionsSet)i.next()).getPermittedRoles());
        }
        return permittedRoles;
    }

    private String getHMCShortId() {
        UIObjectsReader reader = ControllerServlet.getUIObjectsReader();
        Set ids = reader.getShortIdsByType((byte)55);
        return (String)ids.iterator().next();
    }

    static {
        CONSOLE_TASK_KEYS_REQUIRING_TARGET.add("base.task.hwmsg");
    }
}

